/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.SettableObservable;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00028\u0000H\u00a6\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\n\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\fH&\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0010H&\u00a2\u0006\u0004\b\u0016\u0010\u0006J!\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00028\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H$\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001e\u001a\u00020\u00102\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b \u0010!J \u0010\"\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b\"\u0010\u0018J\u001f\u0010%\u001a\u00020\u00102\u0006\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010'\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b)\u0010\u001bJ\u0017\u0010)\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b)\u0010!J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020*H\u0086\u0002\u00a2\u0006\u0004\b\b\u0010,J\u0017\u0010/\u001a\u00020\u00102\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b/\u00100J\u001f\u00103\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u00102\u001a\u000201H&\u00a2\u0006\u0004\b3\u00104J%\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010.\u001a\u00020-2\u0006\u00102\u001a\u000201H&\u00a2\u0006\u0004\b5\u00106J\u0017\u00109\u001a\u00020\u00102\u0006\u00108\u001a\u000207H\u0016\u00a2\u0006\u0004\b9\u0010:J\u001f\u0010;\u001a\u0002072\u0006\u00108\u001a\u0002072\u0006\u00102\u001a\u000201H&\u00a2\u0006\u0004\b;\u0010<J%\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00108\u001a\u0002072\u0006\u00102\u001a\u000201H&\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010?\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010.\u001a\u00020-H&\u00a2\u0006\u0004\b?\u0010@J\u001d\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000A2\u0006\u0010.\u001a\u00020-H&\u00a2\u0006\u0004\bB\u0010CJ\u0015\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00100DH&\u00a2\u0006\u0004\bE\u0010FR\u0014\u0010+\u001a\u00020*8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006I"}, d2={"Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/cobblemon/mod/common/api/storage/StorePosition;", "T", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "<init>", "()V", "position", "get", "(Lcom/cobblemon/mod/common/api/storage/StorePosition;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/StorePosition;", "Lnet/minecraft/class_3222;", "getObservingPlayers", "()Ljava/lang/Iterable;", "player", "", "sendTo", "(Lnet/minecraft/class_3222;)V", "pokemon", "onPokemonChanged", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "initialize", "setAtPosition", "(Lcom/cobblemon/mod/common/api/storage/StorePosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "isValidPosition", "(Lcom/cobblemon/mod/common/api/storage/StorePosition;)Z", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "sendPacketToObservers", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "add", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "set", "position1", "position2", "swap", "(Lcom/cobblemon/mod/common/api/storage/StorePosition;Lcom/cobblemon/mod/common/api/storage/StorePosition;)V", "move", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/storage/StorePosition;)V", "remove", "Ljava/util/UUID;", "uuid", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lnet/minecraft/class_2487;", "nbt", "handleInvalidSpeciesNBT", "(Lnet/minecraft/class_2487;)V", "Lnet/minecraft/class_5455;", "registryAccess", "saveToNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lnet/minecraft/class_2487;", "loadFromNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/google/gson/JsonObject;", "json", "handleInvalidSpeciesJSON", "(Lcom/google/gson/JsonObject;)V", "saveToJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "savePositionToNBT", "(Lcom/cobblemon/mod/common/api/storage/StorePosition;Lnet/minecraft/class_2487;)V", "Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "loadPositionFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "Lcom/cobblemon/mod/common/api/reactive/Observable;", "getAnyChangeObservable", "()Lcom/cobblemon/mod/common/api/reactive/Observable;", "getUuid", "()Ljava/util/UUID;", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonStore.kt\ncom/cobblemon/mod/common/api/storage/PokemonStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1869#2,2:174\n1#3:176\n*S KotlinDebug\n*F\n+ 1 PokemonStore.kt\ncom/cobblemon/mod/common/api/storage/PokemonStore\n*L\n73#1:174,2\n*E\n"})
public abstract class PokemonStore<T extends StorePosition>
implements Iterable<Pokemon>,
KMappedMarker {
    @NotNull
    public abstract UUID getUuid();

    @Nullable
    public abstract Pokemon get(@NotNull T var1);

    @Nullable
    public abstract T getFirstAvailablePosition();

    @NotNull
    public abstract Iterable<class_3222> getObservingPlayers();

    public abstract void sendTo(@NotNull class_3222 var1);

    public abstract void onPokemonChanged(@NotNull Pokemon var1);

    public abstract void initialize();

    protected abstract void setAtPosition(@NotNull T var1, @Nullable Pokemon var2);

    public abstract boolean isValidPosition(@NotNull T var1);

    public void sendPacketToObservers(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        Iterable<class_3222> $this$forEach$iv = this.getObservingPlayers();
        boolean $i$f$forEach = false;
        Iterator<class_3222> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            class_3222 element$iv;
            class_3222 it = element$iv = iterator.next();
            boolean bl = false;
            CobblemonNetwork.INSTANCE.sendPacket(it, packet);
        }
    }

    public boolean add(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        this.remove(pokemon);
        T t = this.getFirstAvailablePosition();
        if (t == null) {
            return false;
        }
        T position = t;
        this.set(position, pokemon);
        return true;
    }

    public void set(@NotNull T position, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Pokemon existing = this.get(position);
        if (Intrinsics.areEqual((Object)existing, (Object)pokemon)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)existing, (Object)pokemon) && existing != null) {
            this.remove(existing);
        }
        this.setAtPosition(position, pokemon);
        pokemon.getStoreCoordinates().set(new StoreCoordinates<T>(this, position));
    }

    public void swap(@NotNull T position1, @NotNull T position2) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter(position1, (String)"position1");
            Intrinsics.checkNotNullParameter(position2, (String)"position2");
            Pokemon pokemon1 = this.get(position1);
            Pokemon pokemon2 = this.get(position2);
            this.setAtPosition(position1, pokemon2);
            this.setAtPosition(position2, pokemon1);
            Object object2 = pokemon1;
            if (object2 != null && (object2 = ((Pokemon)object2).getStoreCoordinates()) != null) {
                ((SettableObservable)object2).set(new StoreCoordinates<T>(this, position2));
            }
            if ((object = pokemon2) == null || (object = ((Pokemon)object).getStoreCoordinates()) == null) break block1;
            ((SettableObservable)object).set(new StoreCoordinates<T>(this, position1));
        }
    }

    public final void move(@NotNull Pokemon pokemon, @NotNull T position) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter(position, (String)"position");
        StoreCoordinates<?> storeCoordinates = pokemon.getStoreCoordinates().get();
        if (storeCoordinates == null) {
            return;
        }
        StoreCoordinates<?> currentPosition = storeCoordinates;
        if (!Intrinsics.areEqual(currentPosition.getStore(), (Object)this)) {
            return;
        }
        Object obj = currentPosition.getPosition();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type T of com.cobblemon.mod.common.api.storage.PokemonStore");
        this.swap(obj, position);
    }

    public boolean remove(@NotNull T position) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        Pokemon pokemon = this.get(position);
        if (pokemon != null) {
            return this.remove(pokemon);
        }
        return false;
    }

    public boolean remove(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        StoreCoordinates<?> storeCoordinates = pokemon.getStoreCoordinates().get();
        if (storeCoordinates == null) {
            return false;
        }
        StoreCoordinates<?> currentPosition = storeCoordinates;
        if (!Intrinsics.areEqual(currentPosition.getStore(), (Object)this)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.get(currentPosition.getPosition()), (Object)pokemon)) {
            return false;
        }
        pokemon.recall();
        pokemon.getStoreCoordinates().set(null);
        this.setAtPosition(currentPosition.getPosition(), null);
        return true;
    }

    @Nullable
    public final Pokemon get(@NotNull UUID uuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable iterable = this;
            for (Object t : iterable) {
                Pokemon it = (Pokemon)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)uuid)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public void handleInvalidSpeciesNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Cobblemon.LOGGER.error("Failed to read unknown species: " + nbt.method_10558("Species"));
    }

    @NotNull
    public abstract class_2487 saveToNBT(@NotNull class_2487 var1, @NotNull class_5455 var2);

    @NotNull
    public abstract PokemonStore<T> loadFromNBT(@NotNull class_2487 var1, @NotNull class_5455 var2);

    public void handleInvalidSpeciesJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Cobblemon.LOGGER.error("Failed to read unknown species: " + json.get("Species").getAsString());
    }

    @NotNull
    public abstract JsonObject saveToJSON(@NotNull JsonObject var1, @NotNull class_5455 var2);

    @NotNull
    public abstract PokemonStore<T> loadFromJSON(@NotNull JsonObject var1, @NotNull class_5455 var2);

    public abstract void savePositionToNBT(@NotNull T var1, @NotNull class_2487 var2);

    @NotNull
    public abstract StoreCoordinates<T> loadPositionFromNBT(@NotNull class_2487 var1);

    @NotNull
    public abstract Observable<Unit> getAnyChangeObservable();

    @Override
    public Iterator<Pokemon> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

